/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

var chart = new Highcharts.Chart('regions_div', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Monthly Store Sale Report'
    },
    xAxis: {
        categories: [
            'Jan',
            'Feb',
            'Mar',
            'Apr',
            'May',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Oct',
            'Nov',
            'Dec'
        ],
        crosshair: true
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Amount (Rs.)'
        }
    },
    tooltip: {
        headerFormat: '<span style="font-size:10px">Month : {point.key}</span><table>',
        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>Rs. {point.y:.2f}</b></td></tr>',
        footerFormat: '</table>',
        shared: true,
        useHTML: true
    },
    plotOptions: {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    },
    series: updateChart("sale")
}, function (chart) {
    setInterval(function () {
        var newSeries = updateChart("sale");
        // Udate the series again with the current data
    }, 60000);
});
//            function updateChart(mode) {
//                if (mode == "sale") {
//                    updateChartSale();
//                }
//            }
function updateChart() {
    getSalesMonthlyList();
    var myData = $("#dashSale").val();
    myData = JSON.parse(myData);
    var mySeries = [];
    for (var i = 0; i < myData.length; i++) {
        var myD = myData[i];
        if (!(i in mySeries)) {
            mySeries[i] = [];
        }
        if (!("name" in mySeries[i])) {
            mySeries[i]["name"] = myD.name;
        }
        if (!("data" in mySeries[i])) {
            mySeries[i]["data"] = myD.data;
        }
    }
    return mySeries;
}

function getSaleChart() {
    updateChart();
}
